/////////////////////////////////////////////////////////////////////////////////

// Original obtained from ShaderToy.com
// Adapted, trivialy, for VGHD by TheEmu.

uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

// Use defines here rather than edit the body of the code.

#define iGlobalTime u_Elapsed
#define iResolution u_WindowSize
#define iMouse vec4(0.0,0.0, 0.0,0.0)

/////////////////////////////////////////////////////////////////////////////////

// The ShaderToy shaders often use textures as inputs named iChannel0. With VGHD
// this may access a Sprite, ClipSprite or ClipNameSprite image depending on how
// the .scn file declares them.
//
// Note, the name used here does not seem to make any difference, so I have used
// iChannel0 which is what is used by ShaderToy but you can use any name as long
// as it matches the use in the main body of the shader. TheEmu.

uniform sampler2D iChannel0;
uniform sampler2D iChannel1;

// With VGHD the range of the P argument's components of the texture functions is
// 0.0 to 1.0 whereas with ShaderToy it seems that the upper limits are given  by
// the number of pixels in each direction, typically 512 or 64.  We therefore use
// the following functions instead.

vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}

// Rather than edit the body of the original shader we use use a define  here  to
// redirect texture calls to the above functions.

#define texture2D texture2D_Fract

/////////////////////////////////////////////////////////////////////////////////

vec3 texCol(vec2 p, float b)
{
    vec3 col = texture2D(iChannel0, p, b).xyz; //b selects mip level
    col *= (col.x+col.y+col.z)/3.0; //gamma
    return col;
}

vec2 perlin(vec2 p)
{
    vec2 x = vec2(0.0);
    for (int i = 0; i < 6; ++i)
    {
        float j = pow(2.0, float(i));
        x += ( texture2D(iChannel1, p*j*0.001).xy - 0.5 ) / j;
    }
    return x;
}

//p = uv, o = random offset for per-pixel noise variation, t = time
vec3 smoke(vec2 p, vec2 o, float t)
{
    const int steps = 10;
    vec3 col = vec3(0.0);
    for (int i = 1; i < steps; ++i)
    {
        //step along a random path that grows in size with time
        p += perlin(p + o) * t * 0.01 / float(i);
        p.y -= t * 0.003; //drift upwards
        
        //sample colour at each point, using mipmaps for blur
        col += texCol(p, float(steps-i) * t * 0.2);
    }
    return col.xyz / float(steps);
}

void main(void)
{
	vec2 uv = gl_FragCoord.xy / iResolution.xy;
    float t = fract(iGlobalTime / 3.0) * 6.0;
    t = max(0.0, t - uv.x - 1.0 + uv.y); //start from top left
    t *= t; //start slow and get faster
	gl_FragColor = vec4(smoke(uv, gl_FragCoord.xy/2.0, t), 1.0);
}